/* Battle.net CD-Key Algorithm Source Code  YobGuls (yobguls@yobguls.2ndmail.com) 2001
 * This source will decode a CD-Key from either Starcraft or Diablo 2
 * into the three values that need to be sent to Battle.net to verify it
 * The DecodeCDKey function works for either D2 or SC keys currently */

#include "stdafx.h"

#ifdef __cplusplus
extern "C"
{
#endif

/* DecodeCDKey
 * This function will take in the CD-Key as a string, and output the three
 * values.  It will also return true or false depending upon whether or not
 * the key is valid for an installation. */

BOOL DecodeCDKey(LPCTSTR, DWORD *, DWORD *, DWORD *);

/* DecodeStarcraftKey
 * Decodes amd checks a Starcraft CD-key */
 
BOOL DecodeStarcraftKey(LPSTR);

/* DecodeD2Key
 * Decodes and checks a Diablo 2 CD-key */

BOOL DecodeD2Key(LPSTR);

/* Get_Hex_Value
 * Converts a number into an ASCII hexadecimal digit */

char Get_Hex_Value(DWORD);

/* Get_Num_Value
 * Converts an ASCII hexadecimal digit into a number */

int Get_Num_Value(char);

void HashData(LPVOID lpSource, int nLength, LPVOID lpResult);

#ifdef __cplusplus
}
#endif
